//
//  GHStressData.h
//  Garmin Health
//
//  Created by Echeandia, Augie on 3/27/17.
//  Copyright © 2017 Garmin International, Inc. or its affiliates. All rights reserved.
//

#import <Foundation/Foundation.h>

/**
 *  The GHStressData class provides the stress data that was extracted from the Garmin device.
 */
@interface GHStressData : NSObject <NSCoding>

/** Timestamp for the associated stress data. Can be null. */
@property (nullable, nonatomic, readonly) NSDate *timestamp;

/** 
 * Stress level number. Value are in the 0-100 range where values of 25 or less
 * indicates resting. A value of -1 indicates the device is off wrist, -2 indicates
 * too much motion, and -3 indicates that there is not enough data to calculate a
 * stress level. Can be null.
 * @note Values are integers.
 */
@property (nullable, nonatomic, readonly) NSNumber *stressLevel;

/** 
 * Averaged stress level over a period of time. Values are integers and range
 * from -100 to 100 with 101 meaning off wrist and 102 meaning too much movement.
 * Positive numbers indicate relaxed and negative numbers indicate stress. Can be null. 
 * @note Values are integers and range from -100 to 100. 101 means unmeasurable. 102 means active.
 */
@property (nullable, nonatomic, readonly) NSNumber *averageIntensity;


@end
